#!/bin/sh

# $1 should contain all the command line arguments of tcpdump
# $2 should be name of the file which will be saved on client's PC

# If packet capture is already running, don't start another process. This check will
# prevent the user from starting multiple downloads by enabling "Start" button by editing
# html or javascript.

PIDS=$(pgrep tcpdump)
# awk is called seperately because adding pipe in last command causes extra entry in
# output of pgrep as grep is part of pgrep and causes incorrect result
COUNT=$(echo $PIDS | awk '{print NF}')

if [ $COUNT -gt 0 ];then
	echo -ne "Cache-Control:no-cache,no-store,must-revalidate\r\n";
	echo -ne "Content-Type:text/html;charset=utf-8\r\n\r\n";
	echo -ne "<script>alert('Network traffic capture is already running');
		parent.document.getElementById('Debugging').click();</script>";
else
	echo -ne "Content-Disposition:attachment;filename=$2\r\n";
	echo -ne "Content-Type:application/octet-stream;charset=utf-8\r\n\r\n";
	tcpdump $1;
fi
